//
// testXMLSQL.java
//
// import the Oracle driver
import oracle.jdbc.*;
// import the query class
import oracle.xml.sql.query.OracleXMLQuery;
import java.lang.*;
import java.sql.*;

// define a class to test String generation
class testXMLSQL 
{
  public static void main(String[] argv)
  {
    try
    {
// create the connection to hr schema of the database
      Connection conn  = getConnection("hr","hr");

// create the query object
      OracleXMLQuery qry = new OracleXMLQuery(conn, "SELECT * FROM employees");

// get the XML string
      String str = qry.getXMLString();

// print the XML output
      System.out.println(" The XML output is:\n"+str);

// close the query to get rid of any resources
      qry.close();
    }
    catch(SQLException e)
    {
      System.out.println(e.toString());
    }
  } // end main

// obtain the connection given the user name and password
  private static Connection getConnection(String username, String password)
    throws SQLException
  {
// register the JDBC driver
    DriverManager.registerDriver(new oracle.jdbc.OracleDriver());

// create the connection using the OCI driver
    Connection conn =
      DriverManager.getConnection("jdbc:oracle:oci:@",username,password);
    return conn;
   } // end getConnection
}
